
<?php $__env->startSection('header'); ?>
    <script src="<?php echo e(asset('asset/script/coupons.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card mt-3">
        <div class="card-header">
            <h4><?php echo e(__('Coupons')); ?></h4>

            <a data-toggle="modal" data-target="#addCouponModal" href=""
                class="ml-auto btn btn-primary text-white"><?php echo e(__('Add Coupon')); ?></a>
        </div>
        <div class="card-body">
            <div class="table-responsive col-12">
                <table class="table table-striped w-100 word-wrap" id="couponsTable">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Coupon')); ?></th>
                            <th><?php echo e(__('Percentage')); ?></th>
                            <th><?php echo e(__('Max. Discount Amount')); ?></th>
                            <th><?php echo e(__('Heading')); ?></th>
                            <th><?php echo e(__('Description')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>

        </div>
    </div>

    
    <div class="modal fade" id="editCouponModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5><?php echo e(__('Edit Coupon')); ?></h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="" method="post" enctype="multipart/form-data" id="editCouponForm"
                        autocomplete="off">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="id" id="editCouponId">

                        <div class="form-group">
                            <label> <?php echo e(__('Coupon')); ?></label>
                            <input id="editCoupon" type="text" name="coupon" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label> <?php echo e(__('Heading')); ?></label>
                            <input id="editHeading" type="text" name="heading" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label> <?php echo e(__('Description')); ?></label>
                            <input id="editDescription" type="text" name="description" class="form-control" required>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-6">
                                <label> <?php echo e(__('Percentage')); ?></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            %
                                        </div>
                                    </div>
                                    <input id="editPercentage" name="percentage" type="number"
                                        class="form-control currency" required>
                                </div>
                            </div>

                            <div class="form-group col-6">
                                <label><?php echo e(__('Max. Discount Amount')); ?></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <?php echo e($settings->currency); ?>

                                        </div>
                                    </div>
                                    <input id="editMaxDiscAmount" name="max_discount_amount" type="number"
                                        class="form-control currency" required>
                                </div>
                            </div>


                        </div>
                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>
    
    <div class="modal fade" id="addCouponModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5><?php echo e(__('Add Coupon')); ?></h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="" method="post" enctype="multipart/form-data" id="addCouponForm" autocomplete="off">
                        <?php echo csrf_field(); ?>

                        <div class="form-group">
                            <label> <?php echo e(__('Coupon')); ?></label>
                            <input type="text" name="coupon" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label> <?php echo e(__('Heading')); ?></label>
                            <input type="text" name="heading" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label> <?php echo e(__('Description')); ?></label>
                            <input type="text" name="description" class="form-control" required>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-6">
                                <label> <?php echo e(__('Percentage')); ?></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            %
                                        </div>
                                    </div>
                                    <input name="percentage" type="number" class="form-control currency" required>
                                </div>
                            </div>
                            <div class="form-group col-6">
                                <label><?php echo e(__('Max. Discount Amount')); ?></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <?php echo e($settings->currency); ?>

                                        </div>
                                    </div>
                                    <input name="max_discount_amount" type="number" class="form-control currency"
                                        required>
                                </div>
                            </div>


                        </div>
                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\doctorio_backend\resources\views/coupons.blade.php ENDPATH**/ ?>