
<?php $__env->startSection('header'); ?>
    <script src="<?php echo e(asset('asset/script/viewUserProfile.js')); ?>"></script>
    <link rel="stylesheet" href="<?php echo e(asset('asset/style/viewUserProfile.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <input type="hidden" value="<?php echo e($user->id); ?>" id="userId">

    <div class="card">
        <div class="card-header">
            <img class="rounded-circle owner-img-border mr-2" width="40" height="40"
                src="<?php echo e(env('FILES_BASE_URL')); ?><?php echo e($user->profile_image); ?>" alt="">
            <h4 class="d-inline">
                <span><?php echo e($user->fullname); ?></span>
            </h4>
            <span>- <?php echo e($user->identity); ?></span>

            
            <a href="" id="rechargeWallet" class="ml-auto btn btn-primary text-white"><?php echo e(__('Recharge Wallet')); ?></a>

            
            <?php if($user->is_block == 1): ?>
                <a href="" id="unblockUser" class="ml-2 btn btn-success text-white"><?php echo e(__('Unblock')); ?></a>
            <?php else: ?>
                <a href="" id="blockUser" class="ml-2 btn btn-danger text-white"><?php echo e(__('Block')); ?></a>
            <?php endif; ?>

        </div>
        <div class="card-body">
            <div class="form-row">
                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('Wallet')); ?></label>
                    <p class="mt-0 p-data"><?php echo e($settings->currency); ?><?php echo e($user->wallet); ?></p>
                </div>
                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('Total Appointments')); ?></label>
                    <p class="mt-0 p-data"><?php echo e($totalAppointments); ?></p>
                </div>
            </div>


        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <ul class="nav nav-pills border-b  ml-0">

                <li role="presentation" class="nav-item "><a class="nav-link pointer active" href="#tabBookings"
                        role="tab" aria-controls="tabBookings" data-toggle="tab"><?php echo e(__('Appointments')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabPatients" role="tab"
                        data-toggle="tab"><?php echo e(__('Patients')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>

                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabWallet" role="tab"
                        data-toggle="tab"><?php echo e(__('Wallet')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabWithdrawRequests"
                        role="tab" data-toggle="tab"><?php echo e(__('Payouts')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabWalletRechargeLogs"
                        role="tab" data-toggle="tab"><?php echo e(__('Wallet Recharges')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>


            </ul>
        </div>
        <div class="card-body">
            <div class="tab-content tabs" id="home">
                
                <div role="tabpanel" class="tab-pane active" id="tabBookings">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="appointmentsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Appointments Number')); ?></th>
                                    <th><?php echo e(__('Doctor')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Date & Time')); ?></th>
                                    <th><?php echo e(__('Service Amount')); ?></th>
                                    <th><?php echo e(__('Discount Amount')); ?></th>
                                    <th><?php echo e(__('Subtotal')); ?></th>
                                    <th><?php echo e(__('Total Tax Amount')); ?></th>
                                    <th><?php echo e(__('Payable Amount')); ?></th>
                                    <th><?php echo e(__('Order Date')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <div role="tabpanel" class="tab-pane" id="tabWallet">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="walletStatementTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Transaction ID')); ?></th>
                                    <th><?php echo e(__('Summary')); ?></th>
                                    <th><?php echo e(__('Amount')); ?></th>
                                    <th><?php echo e(__('Credit/Debit')); ?></th>
                                    <th><?php echo e(__('Date & Time')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div role="tabpanel" class="tab-pane" id="tabWithdrawRequests">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="tabWithdrawRequestsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Request Number')); ?></th>
                                    <th><?php echo e(__('Bank Details')); ?></th>
                                    <th><?php echo e(__('Amount & Status')); ?></th>
                                    <th><?php echo e(__('Placed On')); ?></th>
                                    <th><?php echo e(__('Summary')); ?></th>
                                    <th><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div role="tabpanel" class="tab-pane" id="tabWalletRechargeLogs">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="walletRechargeLogsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Amount')); ?></th>
                                    <th><?php echo e(__('Gateway')); ?></th>
                                    <th><?php echo e(__('Transaction ID')); ?></th>
                                    <th><?php echo e(__('Transaction Summary')); ?></th>
                                    <th><?php echo e(__('Date')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div role="tabpanel" class="tab-pane" id="tabPatients">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="patientsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Image')); ?></th>
                                    <th><?php echo e(__('Name')); ?></th>
                                    <th><?php echo e(__('Age')); ?></th>
                                    <th><?php echo e(__('Gender')); ?></th>
                                    <th><?php echo e(__('Relation')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="rejectModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5><?php echo e(__('Reject Withdrawal')); ?></h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="" method="post" enctype="multipart/form-data" id="rejectForm"
                        autocomplete="off">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" id="rejectId" name="id">
                        <div class="form-group">
                            <label> <?php echo e(__('Summary')); ?></label>
                            <textarea rows="10" style="height:200px !important;" type="text" name="summary" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>
    
    <div class="modal fade" id="completeModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5><?php echo e(__('Complete Withdrawal')); ?></h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="" method="post" enctype="multipart/form-data" id="completeForm"
                        autocomplete="off">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" id="completeId" name="id">
                        <div class="form-group">
                            <label> <?php echo e(__('Summary')); ?></label>
                            <textarea rows="10" style="height:200px !important;" type="text" name="summary" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>


    
    <div class="modal fade" id="rechargeWalletModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5><?php echo e(__('Recharge Wallet')); ?></h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="" method="post" enctype="multipart/form-data" id="rechargeWalletForm"
                        autocomplete="off">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="user_id" value="<?php echo e($user->id); ?>">
                        <input type="hidden" name="transaction_id" value="<?php echo e(__('ADDED_BY_ADMIN')); ?>">
                        <input type="hidden" name="gateway" value="2"> 


                        <div class="form-group">
                            <label> <?php echo e(__('Amount')); ?></label>
                            <input type="number" name="amount" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label> <?php echo e(__('Transaction Summary')); ?></label>
                            <textarea name="transaction_summary" class="form-control" required></textarea>
                        </div>

                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\doctorio_backend\resources\views/viewUserProfile.blade.php ENDPATH**/ ?>