<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title><?php echo e(__('App Name')); ?></title>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!-- include summernote css/js -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>

    <?php echo $__env->yieldContent('header'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('asset/css/app.min.css')); ?>">

    <link href="<?php echo e(asset('asset/css/style.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('asset/css/components.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/css/custom.css')); ?>">

    <link rel='shortcut icon' type='image/x-icon' href='<?php echo e(asset('asset/img/favicon.ico')); ?>'
        style="width: 2px !important;" />

    <link rel="stylesheet" href="<?php echo e(asset('asset/bundles/codemirror/lib/codemirror.css')); ?>">
    <link rel="stylesheet" href=" <?php echo e(asset('asset/bundles/codemirror/theme/duotone-dark.css')); ?> ">
    <link rel="stylesheet" href=" <?php echo e(asset('asset/bundles/jquery-selectric/selectric.css')); ?>">
    <script src="<?php echo e(asset('asset/cdnjs/iziToast.min.js')); ?>"></script>

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('asset/cdncss/iziToast.css')); ?>" />
    <script src="<?php echo e(asset('asset/cdnjs/sweetalert.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/script/env.js')); ?>"></script>
    <link rel="stylesheet" href="<?php echo e(asset('asset/style/app.css')); ?>">

</head>

<body>
    

    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <div class="navbar-bg"></div>
            <nav class="navbar navbar-expand-lg main-navbar sticky">
                <div class="form-inline mr-auto">
                    <ul class="navbar-nav mr-3">
                        <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg
									collapse-btn">
                                <i data-feather="align-justify"></i></a></li>
                    </ul>
                </div>
                <ul class="navbar-nav navbar-right">

                    <li class="dropdown"><a href="#" data-toggle="dropdown"
                            class="nav-link dropdown-toggle nav-link-lg nav-link-user"> <span
                                class="d-sm-none d-lg-inline-block btn btn-light"> <?php echo e(__('Log Out')); ?> </span></a>
                        <div class="dropdown-menu dropdown-menu-right pullDown">

                            <a href="<?php echo e(route('logout')); ?>" class="dropdown-item has-icon text-danger"> <i
                                    class="fas fa-sign-out-alt"></i>
                                <?php echo e(__('Log Out')); ?>

                            </a>
                        </div>
                    </li>
                </ul>
            </nav>
            <div class="main-sidebar sidebar-style-2">
                <aside id="sidebar-wrapper">
                    <div class="sidebar-brand">
                        <a href="<?php echo e(route('index')); ?>"> <span class="logo-name"> <?php echo e(__('App Name')); ?> </span>
                        </a>
                    </div>
                    <ul class="sidebar-menu">

                        <li class="menu-header"><?php echo e(__('Main')); ?></li>

                        <li class="sideBarli  indexSideA">
                            <a href="<?php echo e(route('index')); ?>" class="nav-link"><i class="fas fa-tachometer-alt"></i><span>
                                    <?php echo e(__('Dashboard')); ?> </span></a>
                        </li>

                        <li class="sideBarli  usersSideA">
                            <a href="<?php echo e(route('users')); ?>" class="nav-link"><i class="fa fa-users"></i><span>
                                    <?php echo e(__('Users')); ?> </span></a>
                        </li>

                        <li class="sideBarli  doctorsSideA">
                            <a href="<?php echo e(route('doctors')); ?>" class="nav-link"><i class="fas fa-plus-square"></i><span>
                                    <?php echo e(__('Doctors')); ?> </span></a>
                        </li>
                        <li class="sideBarli  appointmentsSideA">
                            <a href="<?php echo e(route('appointments')); ?>" class="nav-link"><i
                                    class="fas fa-calendar-check"></i><span>
                                    <?php echo e(__('Appointments')); ?> </span></a>
                        </li>

                        <li class="sideBarli  reviewsSideA">
                            <a href="<?php echo e(route('reviews')); ?>" class="nav-link"><i class="fas fa-star"></i><span>
                                    <?php echo e(__('Reviews')); ?> </span></a>
                        </li>
                        <li class="sideBarli  couponsSideA">
                            <a href="<?php echo e(route('coupons')); ?>" class="nav-link"><i class="fas fa-tag"></i><span>
                                    <?php echo e(__('Coupons')); ?> </span></a>
                        </li>
                        <li class="sideBarli  reelsSideA">
                            <a href="<?php echo e(route('reels')); ?>" class="nav-link"><i class="fas fa-play"></i><span>
                                    <?php echo e(__('Reels')); ?> </span></a>
                        </li>

                        <li class="sideBarli  reportsSideA">
                            <a href="<?php echo e(route('reports')); ?>" class="nav-link"><i class="fas fa-info-circle"></i><span>
                                    <?php echo e(__('Reel Reports')); ?> </span></a>
                        </li>

                        <li class="sideBarli  faqsSideA">
                            <a href="<?php echo e(route('faqs')); ?>" class="nav-link"><i class="fas fa-question-circle"></i><span>
                                    <?php echo e(__('FAQs')); ?> </span></a>
                        </li>
                        <li class="sideBarli  notificationsSideA">
                            <a href="<?php echo e(route('notifications')); ?>" class="nav-link"><i class="fa fa-bell"></i><span>
                                    <?php echo e(__('Notifications')); ?> </span></a>
                        </li>
                        <li class="menu-header"><?php echo e(__('Business')); ?></li>

                        <li class="sideBarli  userWithdrawsSideA">
                            <a href="<?php echo e(route('userWithdraws')); ?>" class="nav-link"><i
                                    class="fas fa-money-bill"></i><span>
                                    <?php echo e(__('User Withdraws')); ?> </span></a>
                        </li>

                        <li class="sideBarli  doctorWithdrawsSideA">
                            <a href="<?php echo e(route('doctorWithdraws')); ?>" class="nav-link"><i
                                    class="fas fa-money-bill"></i><span>
                                    <?php echo e(__('Doctor Withdraws')); ?> </span></a>
                        </li>


                        <li class="sideBarli  platformEarningsSideA">
                            <a href="<?php echo e(route('platformEarnings')); ?>" class="nav-link"><i
                                    class="fas fa-percentage"></i><span>
                                    <?php echo e(__('Platform Earnings')); ?> </span></a>
                        </li>

                        <li class="sideBarli  userWalletRechargeSideA">
                            <a href="<?php echo e(route('userWalletRecharge')); ?>" class="nav-link"><i
                                    class="fas fa-wallet"></i><span>
                                    <?php echo e(__('Recharge Logs (User)')); ?> </span></a>
                        </li>


                        <li class="menu-header"><?php echo e(__('Other Data')); ?></li>
                        <li class="sideBarli  doctorCategoriesSideA">
                            <a href="<?php echo e(route('doctorCategories')); ?>" class="nav-link"><i
                                    class="fas fa-grip-horizontal"></i><span>
                                    <?php echo e(__('Doctor Categories')); ?> </span></a>
                        </li>

                        <li class="sideBarli  settingsSideA">
                            <a href="<?php echo e(route('settings')); ?>" class="nav-link"><i class="fas fa-cog"></i><span>
                                    <?php echo e(__('Settings')); ?> </span></a>
                        </li>


                        <li class="menu-header"><?php echo e(__('Pages')); ?></li>

                        <li class="sideBarli  privacySideA">
                            <a href="<?php echo e(route('viewPrivacy')); ?>" class="nav-link"><i
                                    class="fas fa-info"></i><span><?php echo e(__('Privacy Policy')); ?></span></a>
                        </li>

                        <li class="sideBarli  termsSideA">
                            <a href="<?php echo e(route('viewTerms')); ?>" class="nav-link"><i
                                    class="fas fa-info"></i><span><?php echo e(__('Terms Of Use')); ?></span></a>
                        </li>

                    </ul>
                </aside>
            </div>


            <!-- Main Content -->
            <div class="main-content">

                <?php echo $__env->yieldContent('content'); ?>
                <form action="">
                    <input type="hidden" id="user_type" value="<?php echo e(session('user_type')); ?>">
                </form>

            </div>

        </div>
    </div>



    <script src="<?php echo e(asset('asset/js/app.min.js ')); ?>"></script>


    <script src="<?php echo e(asset('asset/bundles/datatables/datatables.min.js ')); ?>"></script>
    
    <script src="<?php echo e(asset('asset/bundles/jquery-ui/jquery-ui.min.js ')); ?>"></script>

    <script src=" <?php echo e(asset('asset/js/page/datatables.js')); ?>"></script>

    <script src="<?php echo e(asset('asset/js/scripts.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/script/app.js')); ?>"></script>

    <!-- Custom JS File -->
    <script src="<?php echo e(asset('asset/bundles/summernote/summernote-bs4.js ')); ?>"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/printThis/1.15.0/printThis.js"
        integrity="sha512-Fd3EQng6gZYBGzHbKd52pV76dXZZravPY7lxfg01nPx5mdekqS8kX4o1NfTtWiHqQyKhEGaReSf4BrtfKc+D5w=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>



</body>


</html>
<?php /**PATH C:\xampp\htdocs\doctorio_backend\resources\views/include/app.blade.php ENDPATH**/ ?>